package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;


/** 
 * Menu action for quitting the application.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-06-23 Kevin Green
 */

public class FileQuitAction extends AbstractAction {	
	/**
	 *	Set up the quit menu option.
	 */
	public FileQuitAction() {
		super("Quit");
		putValue( AbstractAction.MNEMONIC_KEY,  new Integer(KeyEvent.VK_Q));
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Quit the JEase Application");		
	}
	
	/**
	 * Quits the application, warns if the sketch is dirty.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		Easik.getInstance().getFrame().closeWindow();
	}
}
